
/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于图标按钮编辑
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 巫昭雯
 *      时间 : 2021.4.21
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported mc_construct_icon_btn */

/* global mc_sdk_param */
/* global $ */


/************************************************************************************************
 * 类型:
 *    构造函数
 * 功能:
 *    编辑图标按钮
 * 参数:
 *    NA
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-04-26
 *       内容 : 所有代码
************************************************************************************************/
function mc_construct_icon_btn() {
    var m_this = this;
    // all icon btn sdk param object
    var mo_param_btn = new mc_sdk_param();
    // 1 === edit status; other is normal status
    var m_tatus = 0;

    // ***************************** defind id ***************************** //
    var m_ui_id_layer = "mc_ui_item_icon_btn";
    // var m_ui_id_layout_edit = "mc_ib_id_edit";
    // 按钮包裹层
    var m_ui_id_ly_use = "icon_btn_use";
    var m_ui_id_ly_no_use = "icon_btn_all";
    var m_s_ib_class = "edit_icon_btn";

    // console.log(mo_param_btn);

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    构造编辑块布局
     * 参数:
     *    NA
     * 返回:
     *    @returns { Promise<String> } html 字符串
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-04-26
     *       内容 : 所有代码
    ************************************************************************************************/
    function construct_str_html() {
        var ui_len = mo_param_btn.get_param_cnt();
        var s_html = "";
        var str_use = "";
        var ui_sort_i = 0;
        var ui_sort_i_use = 0;

        for (var idx = 0; idx < ui_len; idx++) {
            var s_name = mo_param_btn.get_param_name(idx);
            // var s_use = mo_param_btn.get_param_value(s_name);
            var s_use = mo_param_btn.get_attr_val(s_name, "USE");
            var s_icon = mo_param_btn.get_attr_val(s_name, "ICON");
            var fn = mo_param_btn.get_attr_val(s_name, "FN");

            if (s_name) {
                ui_sort_i++;
                mo_param_btn.set_param_value(s_name, ui_sort_i + "");
                if ("string" === typeof s_use && (s_use = s_use.trim()) && "true" === s_use) {
                    // shortcut
                    ui_sort_i_use++;
                    mo_param_btn.set_attr_val(s_name, "USE_I", ui_sort_i_use + "");
                    str_use += get_btn_str_html(s_name, s_icon, fn);
                    continue;
                }
                s_html += get_btn_str_html(s_name, s_icon, fn);
            }
        }

        // 分块显示
        var str_use_wrap = get_fold_panel_div_html("MC_LANG_ICON_BTN_EDIT_SHORTCUT_BTN", str_use);
        var str_no_use = get_fold_panel_div_html("MC_LANG_ICON_BTN_EDIT_OTHER_BTN", s_html);
        var html = "<div id='" + m_ui_id_ly_use + "' class='ibtn_layer'>" + str_use_wrap + "</div>" + "<div class='split_line_row'></div>" + "<div id='" + m_ui_id_ly_no_use + "' class='ibtn_layer'>" + str_no_use + "</div>";

        var str_edit_grp = get_edit_btn_grp();

        return "<div id=" + m_ui_id_layer + " class='dbclick_unchecked flex_box_vertical'>" + str_edit_grp + "<div class='mc_ibe_btn_container'>" + html + "</div>" + "</div>";
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    获取单个图标控件 html
     * 参数:
     *    @param { Promise<String> } s_name 按钮名称; lang_id 值
     *    @param { Promise<String> } s_icon 按钮图标
     *    @param { Promise<String> } fn 按钮调用函数名称
     * 返回:
     *    @returns { Promise<String> } html 字符串
     * 例子:
     *    NA
     * 备注:
     *    edit_status 标识按钮编辑状态 1 === 添加("+") || 0 === 删除("x")
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-04-26
     *       内容 : 所有代码
    ************************************************************************************************/
    function get_btn_str_html(s_name, s_icon, fn) {
        var str_close = "<div class='edit' title='edit'><span></span></div>";
        var str_icon = s_icon || "icon-default";
        var html = "<div class='icon_btn " + str_icon + " " + m_s_ib_class + "' title='" + s_name + "' lang_id='" + s_name +
                    "' data-name_id='" + s_name + "' data-fn='" + fn + "' data-edit_status=''>" + str_close +
                    "<div class='btn_text'><span lang_id='" + s_name + "' title=''>" + s_name + "</span></div> " +
                    "</div>";

        return html;
    }

    // b === 是否隐藏
    // function get_fold_panel_div_html(title, content, b) {
    //     var b_hide = b ? "draw_open" : "";
    //     var s_content_style = b ? "display:none" : "";
    //     var html = "<div class='fold_panel_div " + b_hide + "'><div class='mc_lable_name draw_title '>" +
    //                 "<span lang_id=" + title + " title=''>" + title + "</span>" +
    //                 "<i class='draw_angle icon-arrow-single-up'></i>" +
    //                 "</div><div class='mc_fold_content' style='" + s_content_style + "'><div class='show_or_hide ibtn_inner_wrap'>" + content + "</div></div></div>";

    //     return html;
    // }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    按钮外层块(不使用折叠面板)
     * 参数:
     *    @param { Promise<String> } title 该块标题名称
     *    @param { Promise<String> } content 该块内容(按钮组合html)
     * 返回:
     *    @returns { Promise<String> } 块html字符串
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-04-26
     *       内容 : 所有代码
    ************************************************************************************************/
    function get_fold_panel_div_html(title, content) {
        var html = "<div class='ibtn_title'>" +
                    "<span lang_id=" + title + " title='" + title + "' style=''>" + title + "</span>" +
                    "</div><div class='ibtn_inner_wrap'>" + content +
                    "</div>";

        return html;
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    文字组按钮点击操作 "编辑" || "取消" || "完成"
     * 参数:
     *    @param { Promise<Object> } e 鼠标事件参数 event
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-04-26
     *       内容 : 所有代码
    ************************************************************************************************/
    var operation_grp = function (e) {
        // console.log("点击编辑");
        if (e && e.target) {
            switch (e.target.getAttribute("data-operation")) {
            case "edit":
                m_tatus = 1;
                $("#" + m_ui_id_layer + " .mc_ibe_edit_grp").addClass("edit_status");
                fn_ib_click_edit(e);
                break;
            case "cancel":
                m_tatus = 0;
                $("#" + m_ui_id_layer + " .mc_ibe_edit_grp").removeClass("edit_status");
                fn_ib_click_cancel(e);
                break;
            case "done":
                m_tatus = 0;
                $("#" + m_ui_id_layer + " .mc_ibe_edit_grp").removeClass("edit_status");
                fn_ib_click_done(e);
                break;
            default:
                break;
            }
        }
    };


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    获取编辑按钮组html
     * 参数:
     *    NA
     * 返回:
     *    @returns { Promise<String> } html字符串
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-04-26
     *       内容 : 所有代码
    ************************************************************************************************/
    function get_edit_btn_grp() {
        var html = "<div data-operation='edit' lang_id='MC_LANG_EDIT' title='MC_LANG_EDIT' control_type='ibtn'>编辑</div>" +
                "<div data-operation='cancel' lang_id='MC_LANG_BTN_SCREEN_CANCEL' title='MC_LANG_BTN_SCREEN_CANCEL' control_type='ibtn'>取消</div>" +
                "<div data-operation='done' lang_id='MC_LANG_COMPLETE' title='MC_LANG_COMPLETE' control_type='ibtn'>完成</div>";

        return "<div class='mc_ibe_edit_grp'>" + html + "</div>";
    }

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    初始化注册事件
     * 参数:
     *    NA
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-04-26
     *       内容 : 所有代码
    ************************************************************************************************/
    function init_evet() {
        // 1. icon btn and samll edit icon
        $("#" + m_ui_id_layer + " ." + m_s_ib_class).each(function (i,el) {
            // $(el).hover(btn_hover);
            $(el).click(m_this.icon_btn_click_operation);
        });

        // 2. edit text grp
        $("#" + m_ui_id_layer + " [data-operation]").each(function () {
            $(this).click(operation_grp);
        });
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    点击"编辑"操作
     * 参数:
     *    @param { Promise<String> } e 鼠标事件event
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    该操作之后需要将图标按钮上的小图标显示出来 && 阻止按钮的点击事件 && 取消掉按钮的hover样式
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-04-26
     *       内容 : 所有代码
    ************************************************************************************************/
    function fn_ib_click_edit(e) {  //eslint-disable-line
        if (1 !== m_tatus) {
            return;
        }

        $("#" + m_ui_id_layer + " ." + m_s_ib_class).each(function (i,el) {
            var $el = $(el);

            $el.addClass("edit_status");
            var ui_layer = $el.parents(".ibtn_layer")[0].id;

            switch (ui_layer) {
            case m_ui_id_ly_use:
                $el.addClass("close");
                el.setAttribute("data-edit_status", 0);
                break;
            case m_ui_id_ly_no_use:
                $el.addClass("add");
                el.setAttribute("data-edit_status", 1);
                break;
            default:
                break;
            }
        });
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    点击"取消"操作
     * 参数:
     *    NA
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-04-26
     *       内容 : 所有代码
    ************************************************************************************************/
    function fn_ib_click_cancel() {
        // $("#" + m_ui_id_layer + " ." + m_s_ib_class).each(function () {
        //     // $(this).removeClass("edit_status close add");
        // });
        m_this.open(m_this.container_id);
    }

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    点击"完成"操作
     * 参数:
     *    NA
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-04-26
     *       内容 : 所有代码
    ************************************************************************************************/
    function fn_ib_click_done() {
        $("#" + m_ui_id_layer + " ." + m_s_ib_class).each(function (i) {
            var str_use = "0" === this.getAttribute("data-edit_status") ? "true" : "";
            var str_param_name = this.getAttribute("data-name_id");

            mo_param_btn.set_attr_val(str_param_name, "USE", str_use);
            mo_param_btn.set_attr_val(str_param_name, "USE_I", (i + 1) + "");

            $(this).removeClass("edit_status close add");
        });
    }

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    图标按钮hover -> 小图标样式
     * 参数:
     *    @param { Promise<String> } e 鼠标事件event
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-04-26
     *       内容 : 所有代码
    ************************************************************************************************/
    function btn_hover(e) {  // eslint-disable-line
        // console.log(e);

        if (1 === m_tatus && e) {
            if ("mouseenter" === e.type) {
                $(this).children(".edit").css("background-color", "#9e9e9e");
            }

            if ("mouseleave" === e.type) {
                $(this).children(".edit").css("background-color", "");
            }
        }
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    按钮点击操作;
     * 参数:
     *    @param { Promise<String> } e 鼠标事件event
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    编辑状态下: 切换按钮位置; 添加到快捷区域 || 移除到其他区域
     *    非编辑状态下: 点击按钮可以触发注册时的函数;
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-04-26
     *       内容 : 所有代码
    ************************************************************************************************/
    this.icon_btn_click_operation = function (e) {  // eslint-disable-line
        if (!e) {
            return;
        }


        var el_even = e.currentTarget;
        var str_fn = el_even.getAttribute("data-fn"); // eslint-disable-line

        // 触发注册函数
        if (1 !== m_tatus) {
            // trigger_click_event(0, str_fn, el_even);
            // // 触发按钮点击之后关闭当前窗口
            // m_tatus = 1;
            // m_this.close();
            return;
        }

        // 点击编辑
        var $this = $(this);

        if ($this.hasClass("edit_status")) {
            switch (Number(this.getAttribute("data-edit_status"))) {
            // ibtn_inner_wrap
            case 1:
                // 点击添加
                $("#" + m_ui_id_layer + " #" + m_ui_id_ly_use + " .ibtn_inner_wrap").append(this);
                $this.addClass("close").removeClass("add");
                this.setAttribute("data-edit_status", 0);
                break;
            case 0:
                // 点击删除
                $("#" + m_ui_id_layer + " #" + m_ui_id_ly_no_use + " .ibtn_inner_wrap").append(this);
                $this.addClass("add").removeClass("close");
                this.setAttribute("data-edit_status", 1);
                // 删除要排序
                break;
            default:
                break;
            }
        }
    };


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    触发点击注册函数
     * 参数:
     *    @param { Promise<String> } num 寻找次数
     *    @param { Promise<String> } str_fn 注册的函数名称
     *    @param { Promise<String> } ev 按钮当前dom对象
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    只寻找三层
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-04-26
     *       内容 : 所有代码
    ************************************************************************************************/
    function trigger_click_event(num, str_fn, ev) {  // eslint-disable-line
        var fn_click = null;

        switch (num) {
        case 0:
            fn_click = window[str_fn];
            break;
        // case 1:
        //     fn_click = window[0][str_fn];
        //     break;
        // case 2:
        //     fn_click = window[0][0][str_fn];
        //     break;
        default:
            return;
        }

        if ("function" === typeof fn_click) {
            // 点击按钮
            fn_click(ev);
        } else {
            // 只找三个级别
            trigger_click_event(num + 1, str_fn, ev);
        }
        return;
    }


    // ********************************************************************* 接口 ********************************************************************* //
    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    初始化打开控件;
     * 参数:
     *    @param { Promise<Object> } el_id 存放编辑块的外部容器id
     * 返回:
     *    @returns { Promise<Boolean> } 参数容器dom对象不存在
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-04-26
     *       内容 : 所有代码
    ************************************************************************************************/
    this.open = function (el_id) {
        if ("string" !== typeof el_id) {
            return false;
        }

        var o_el = document.getElementById(el_id);

        if (o_el) {
            this.container_id = el_id;
            o_el.innerHTML = construct_str_html();
            init_evet(o_el);
            return true;
        }

        return false;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    关闭该编辑层时需要触发;
     * 参数:
     *    NA
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    该函数为防止在编辑状态下再次打开时按钮样式未回归正常状态;
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-04-26
     *       内容 : 所有代码
    ************************************************************************************************/
    this.close = function () {
        if (1 === m_tatus) {
            $("#" + m_ui_id_layer + " [data-operation='cancel']").click();
        }
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置图标按钮json串
     * 参数:
     *    @param { Promise<String> } s_json
     * 返回:
     *    @returns { Promise<Boolean> } false === 参数错误
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-04-26
     *       内容 : 所有代码
    ************************************************************************************************/
    this.set_all = function (s_json) {
        if ("string" !== typeof s_json) {
            return false;
        }

        if (mo_param_btn.set_json(s_json)) {
            return true;
        }

        return false;
    };

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    获取设置的json串
     * 参数:
     *    NA
     * 返回:
     *    @returns { Promise<String> } json串
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-04-26
     *       内容 : 所有代码
    ************************************************************************************************/
    this.get_all = function () {
        return mo_param_btn.get_json();
    };


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    获取快捷区域数据;
     * 参数:
     *    NA
     * 返回:
     *    @returns { Promise<Array> } 编辑之后的快捷图标按钮数组;
     * 例子:
     *    NA
     * 备注:
     *    数组内对象说明 {
     *    {
     *        "name_id": 标签翻译name_id,
     *        "dom_id": 标签id,
     *        "icon": 标签图标类,
     *        "fn": 标签点击触发函数,
     *        "idx": 排序; 默认与数组下标一致
     *    }
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2021-04-26
     *       内容 : 所有代码
    ************************************************************************************************/
    this.get_shortcut = function () {
        // console.log(JSON.parse(mo_param_btn.get_json()));
        var ui_len = mo_param_btn.get_param_cnt();
        var arr_res = [];

        for (var idx = 0; idx < ui_len; idx++) {
            var s_name = mo_param_btn.get_param_name(idx);
            var s_use = mo_param_btn.get_attr_val(s_name, "USE");

            if ( s_name && s_use && (s_use = s_use.trim()) && "true" === s_use) {
                var sort_i = mo_param_btn.get_attr_val(s_name, "USE_I");
                var s_dom_id = mo_param_btn.get_attr_val(s_name, "DOM_ID");
                var s_icon = mo_param_btn.get_attr_val(s_name, "ICON");
                var s_fn = mo_param_btn.get_attr_val(s_name, "FN");

                arr_res[sort_i] = {
                    "name_id": s_name,
                    "dom_id": s_dom_id,
                    "icon": s_icon,
                    "fn": s_fn,
                    "idx": sort_i
                };
            }
        }

        return arr_res;
    };
}
